<?php

/***** Declare WooCommerce Compatibility *****/

add_theme_support('woocommerce');
add_theme_support('wc-product-gallery-zoom');
add_theme_support('wc-product-gallery-lightbox');
add_theme_support('wc-product-gallery-slider');

/***** Register WooCommerce Sidebar *****/

function mh_woocommerce_sb_init() {
	register_sidebar(array('name' => esc_html_x('WooCommerce', 'widget area name', 'mh-magazine'), 'id' => 'mh-woocommerce', 'description' => esc_html__('Widget area (sidebar) on WooCommerce pages', 'mh-magazine'), 'before_widget' => '<div id="%1$s" class="mh-widget sb-woocommerce %2$s">', 'after_widget' => '</div>', 'before_title' => '<h4 class="mh-widget-title"><span class="mh-widget-title-inner">', 'after_title' => '</span></h4>'));
}
add_action('widgets_init', 'mh_woocommerce_sb_init');

/***** Custom WooCommerce Markup *****/

remove_action('woocommerce_sidebar', 'woocommerce_get_sidebar', 10);

/***** Retrieve WooCommerce Sidebar *****/

function mh_themes_woocommerce_sb_markup() { ?>
    <aside class="mh-widget-col-1 mh-sidebar mh-woocommerce-sidebar" itemscope="itemscope" itemtype="https://schema.org/WPSideBar"><?php
        if (is_active_sidebar('mh-woocommerce')) {
            dynamic_sidebar('mh-woocommerce');
        } else { ?>
            <div class="mh-widget mh-sidebar-empty">
            <h4 class="mh-widget-title">
                <span class="mh-widget-title-inner">
                    <?php _ex('WooCommerce', 'widget area name', 'mh-magazine'); ?>
                </span>
            </h4>
            <div class="textwidget">
                <?php printf(esc_html__('Please navigate to %1s in your WordPress dashboard and add some widgets into the %1s widget area.', 'mh-magazine'), '<strong>' . __('Appearance &#8594; Widgets', 'mh-magazine') . '</strong>', '<em>' . _x('WooCommerce', 'widget area name', 'mh-magazine') . '</em>'); ?>
            </div>
            </div><?php
        } ?>
    </aside> <?php
}

function mh_themes_wrapper_start() { ?>
	<div class="mh-wrapper clearfix">
		<div class="mh-main clearfix">
            <?php
            $mh_magazine_options = mh_magazine_theme_options();
            $main_content_class = 'mh-content-full';

            if ($mh_magazine_options['sidebars'] != 'disable') {
                if (is_product_category() && !is_shop() && $mh_magazine_options['product_category_sidebar'] == 'enable') {
                    $main_content_class = 'mh-content-with-sidebar';

                } elseif (is_shop() && $mh_magazine_options['shop_page_sidebar'] == 'enable') {
                    $main_content_class = 'mh-content-with-sidebar';

                } elseif (is_product() && $mh_magazine_options['product_sidebar'] == 'enable') {
                    $main_content_class = 'mh-content-with-sidebar';
                }
            } ?>
            <div id="main-content" class="mh-content entry-content <?php echo $main_content_class;?>" role="main"> <?php
}
remove_action('woocommerce_before_main_content', 'woocommerce_output_content_wrapper', 10);
add_action('woocommerce_before_main_content', 'mh_themes_wrapper_start', 10);

function mh_themes_wrapper_end() { ?>
			</div>
			<?php
            $mh_magazine_options = mh_magazine_theme_options();

            if ($mh_magazine_options['sidebars'] != 'disable') {
                if (is_product_category() && !is_shop() && $mh_magazine_options['product_category_sidebar'] == 'enable') {
                    mh_themes_woocommerce_sb_markup();

                } elseif (is_shop() && $mh_magazine_options['shop_page_sidebar'] == 'enable') {
                    mh_themes_woocommerce_sb_markup();

                } elseif (is_product() && $mh_magazine_options['product_sidebar'] == 'enable') {
                    mh_themes_woocommerce_sb_markup();
                }
            } ?>
	  	</div>
	  	<?php mh_magazine_second_sidebar(); ?>
  	</div> <?php
}
remove_action('woocommerce_after_main_content', 'woocommerce_output_content_wrapper_end', 10);
add_action('woocommerce_after_main_content', 'mh_themes_wrapper_end', 10);

/***** Load Custom WooCommerce CSS *****/

function mh_woocommerce_css() {
    wp_register_style('mh-woocommerce', get_template_directory_uri() . '/woocommerce/woocommerce.css');
    wp_enqueue_style('mh-woocommerce');
}
add_action('wp_enqueue_scripts', 'mh_woocommerce_css');

/*****#@+ Meta box for WooCommerce Sidebar at the Shop Page *****/

function mh_themes_woocommerce_sb_add_meta_box($post_type, $post) {
    $shop_page_id = get_option('woocommerce_shop_page_id');

    if ($shop_page_id && $shop_page_id == $post->ID) {
        add_meta_box(
            'mh_magazine_options_shop_page_sidebar',
            esc_html__('WooCommerce Sidebar', 'mh-magazine'),
            'mh_themes_woocommerce_sb_callback',
            null,
            'side',
            'low'
        );
    }
}
add_action( 'add_meta_boxes', 'mh_themes_woocommerce_sb_add_meta_box', 10, 2 );

function mh_themes_woocommerce_sb_callback($post) {

    wp_nonce_field(basename(__FILE__), 'mh-magazine-wc-sb-meta-box-nonce');
    $mh_magazine_options = mh_magazine_theme_options();
    $dropdown_options = array(
        'enable'  => esc_html__('Enable', 'mh-magazine'),
        'disable' => esc_html__('Disable', 'mh-magazine'),
    );
    ?>
    <select id="mh_themes_woocommerce_sidebar_dropdown" name="mh_themes_woocommerce_sidebar_dropdown" style="width: 215px; margin-top: 10px;">
        <?php
        foreach ($dropdown_options as $option_value => $option_name) {
            printf( '<option value="%2$s" %3$s>%1$s</option>',
                esc_html($option_name),
                esc_attr($option_value),
                selected($option_value, $mh_magazine_options['shop_page_sidebar'], false)
            );
        } ?>
    </select>

    <label for="mh_themes_woocommerce_sidebar_dropdown" style="display: block; margin-top: 10px;">
        <em>
            <?php
            echo esc_html__('Depends on', 'mh-magazine') .
                ' <strong> ' . esc_html__('Number of Sidebars', 'mh-magazine') . '</strong> in ' .
                __( 'Appearance' ) . ' &#8594; ' . __( 'Customize' ) . ' &#8594; ' . esc_html__('Theme Options', 'mh-magazine') .
                ' &#8594; ' . esc_html__('Layout - General', 'mh-magazine');
            ?>
        </em>
    </label>
    <?php
}

function mh_themes_woocommerce_sb_save_meta_box($post_id, $post) {
    if (!isset($_POST['mh-magazine-wc-sb-meta-box-nonce']) || !wp_verify_nonce($_POST['mh-magazine-wc-sb-meta-box-nonce'], basename(__FILE__)))
        return $post_id;

    if(!current_user_can('edit_post', $post_id))
        return $post_id;

    if(defined('DOING_AUTOSAVE') && DOING_AUTOSAVE)
        return $post_id;

    $shop_page_id = get_option('woocommerce_shop_page_id');

    if (!$shop_page_id || $shop_page_id != $post_id)
        return $post_id;

    $option = 'shop_page_sidebar';
    $default_options = mh_magazine_default_options();

    $meta_box_dropdown_value = (isset($_POST['mh_themes_woocommerce_sidebar_dropdown'])) ? $_POST['mh_themes_woocommerce_sidebar_dropdown'] :
         $default_options[$option];

    if (!$meta_box_dropdown_value)
        return $post_id;

    $mh_magazine_options = mh_magazine_theme_options();

    foreach ($mh_magazine_options as $key => $value) {
        if ($key == $option) {
            $mh_magazine_options[$key] = $meta_box_dropdown_value;
            break;
        }
    }

    update_option('mh_magazine_options', $mh_magazine_options);
}
add_action('save_post', 'mh_themes_woocommerce_sb_save_meta_box', 10, 2);

/*****#@- Meta box for WooCommerce Sidebar at the Shop Page *****/
