<?php
/**
 * Easy Digital Downloads Theme Updater
 *
 * @package EDD Sample Theme
 */

// Includes the files needed for the theme updater
if ( !class_exists( 'EDD_Theme_Updater_Admin' ) ) {
	include( dirname( __FILE__ ) . '/theme-updater-admin.php' );
}

global $mh_magazine_version;

// Loads the updater classes
$updater = new EDD_Theme_Updater_Admin(

	// Config settings
	$config = array(
		'remote_api_url' => 'https://mhthemes.com', // Site where EDD is hosted
		'item_name'      => 'MH Magazine WordPress Theme', // Name of theme
		'theme_slug'     => 'mh-magazine', // Theme slug
		'version'        => $mh_magazine_version, // The current version of this theme
		'author'         => 'MH Themes', // The author of this theme
		'download_id'    => 28445, // Optional, used for generating a license renewal link
		'renew_url'      => '', // Optional, allows for a custom license renewal link
		'beta'           => false, // Optional, set to true to opt into beta versions
	),

	// Strings
	$strings = array(
		'theme-license'             => __( 'Theme License', 'mh-magazine' ),
		'enter-key'                 => __( 'Enter your theme license key.', 'mh-magazine' ),
		'license-key'               => __( 'License Key', 'mh-magazine' ),
		'license-action'            => __( 'License Action', 'mh-magazine' ),
		'deactivate-license'        => __( 'Deactivate License', 'mh-magazine' ),
		'activate-license'          => __( 'Activate License', 'mh-magazine' ),
		'status-unknown'            => __( 'License status is unknown.', 'mh-magazine' ),
		'renew'                     => __( 'Renew?', 'mh-magazine' ),
		'unlimited'                 => __( 'unlimited', 'mh-magazine' ),
		'license-key-is-active'     => __( 'License key is active.', 'mh-magazine' ),
		'expires%s'                 => __( 'Expires %s.', 'mh-magazine' ),
		'expires-never'             => __( 'Lifetime License.', 'mh-magazine' ),
		'%1$s/%2$-sites'            => __( 'You have %1$s / %2$s sites activated.', 'mh-magazine' ),
		'license-key-expired-%s'    => __( 'License key expired %s.', 'mh-magazine' ),
		'license-key-expired'       => __( 'License key has expired.', 'mh-magazine' ),
		'license-keys-do-not-match' => __( 'License keys do not match.', 'mh-magazine' ),
		'license-is-inactive'       => __( 'License is inactive.', 'mh-magazine' ),
		'license-key-is-disabled'   => __( 'License key is disabled.', 'mh-magazine' ),
		'site-is-inactive'          => __( 'Site is inactive.', 'mh-magazine' ),
		'license-status-unknown'    => __( 'License status is unknown.', 'mh-magazine' ),
		'update-notice'             => __( "Updating this theme will lose any customizations you have made. 'Cancel' to stop, 'OK' to update.", 'mh-magazine' ),
		'update-available'          => __('<strong>%1$s %2$s</strong> is available. <a href="%3$s" class="thickbox" title="%4s">Check out what\'s new</a> or <a href="%5$s"%6$s>update now</a>.', 'mh-magazine' ),
	)

);
