<?php

namespace cnb\admin\legacy;

// don't load directly
defined( 'ABSPATH' ) || die( '-1' );

use cnb\utils\CnbAdminFunctions;
use cnb\CnbHeaderNotices;

class CnbLegacyUpgrade {
    function header() {
        echo 'Sign up for <b>more features</b>';
    }

    private function feature_comparison_free_promobox() {
        ?>
        <div class="cnb-body-column">
            <?php
            ( new CnbAdminFunctions() )->cnb_promobox(
                'blue',
                'Compare features',
                '<table class="cnb-nb-plans">
                  <thead>
                    <tr>
                      <td></td>
                      <th class="cnb-prod-cnb"><h3>No account<br><span style="font-weight:normal;">(Currently active)</span></h3></th>
                      <th class="cnb-prod-nb" colspan="2"><h3>With account<br><span style="font-weight:normal;">(NowButtons.com)</span></h3></th>
                    </tr>
                    <tr class="font-18">
                      <th style="text-align:left; padding-left:10px">Price</th>
                      <th><h4>Free</h4></th>
                      <th><h4>Free</h4></th>
                    </tr>
                  </thead>
                  <tbody>
                    <tr class="line"><td>&nbsp;</td><td></td><td></td></tr>
                    <tr>
                      <th>No. of buttons</th>
                      <td class="value">1</td>
                      <td class="value">5</td>
                    </tr>
                    <tr>
                      <th>Single button</th>
                      <td class="yes">✓</td>
                      <td class="yes">✓</td>
                    </tr>
                    <tr>
                      <th>Buttonbar (full width)</th>
                      <td class="yes">✓</td>
                      <td class="yes">✓</td>
                    </tr>
                    <tr class="line"><td>&nbsp;</td><td></td><td></td></tr>
                    <tr>
                      <th>Phone</th>
                      <td class="yes">✓</td>
                      <td class="yes">✓</td>
                    </tr>
                    <tr>
                      <th>SMS/Text</th>
                      <td>𐄂</td>
                      <td class="yes">✓</td>
                    </tr>
                    <tr>
                      <th>Email</th>
                      <td>𐄂</td>
                      <td class="yes">✓</td>
                    </tr>
                    <tr>
                      <th>Maps</th>
                      <td>𐄂</td>
                      <td class="yes">✓</td>
                    </tr>
                    <tr>
                      <th>URLs</th>
                      <td>𐄂</td>
                      <td class="yes">✓</td>
                    </tr>
                    <tr>
                      <th>Scroll to point</th>
                      <td>𐄂</td>
                      <td class="yes">✓</td>
                    </tr>
                    <tr>
                      <th>WhatsApp</th>
                      <td>𐄂</td>
                      <td class="yes">✓</td>
                    </tr>
                    <tr>
                      <th>Messenger</th>
                      <td>𐄂</td>
                      <td class="yes">✓</td>
                    </tr>
                    <tr>
                      <th>Telegram</th>
                      <td>𐄂</td>
                      <td class="yes">✓</td>
                    </tr>
                    <tr>
                      <th>Signal</th>
                      <td>𐄂</td>
                      <td class="yes">✓</td>
                    </tr>

                    <tr class="line"><td>&nbsp;</td><td></td><td></td></tr>
                    <tr>
                      <th>Mobile</th>
                      <td class="yes">✓</td>
                      <td class="yes">✓</td>
                    </tr>
                    <tr>
                      <th>Desktop</th>
                      <td>𐄂</td>
                      <td class="yes">✓</td>
                    </tr>
                    <tr>
                      <th>Limit appearance</th>
                      <td class="yes">✓</td>
                      <td class="yes">✓</td>
                    </tr>
                    <tr>
                      <th>Display rules (Basic)</th>
                      <td>𐄂</td>
                      <td class="yes">✓</td>
                    </tr>
                    <tr>
                      <th>Click tracking in GA</th>
                      <td class="yes">✓</td>
                      <td class="yes">✓</td>
                    </tr>
                    <tr>
                      <th>Google Ads conversion tracking</th>
                      <td class="yes">✓</td>
                      <td class="yes">✓</td>
                    </tr>
                    <tr>
                      <th>Live preview</th>
                      <td>𐄂</td>
                      <td class="yes">✓</td>
                    </tr>
                    <tr class="line"><td>&nbsp;</td><td></td><td></td></tr>
                  </tbody>
                    <tfoot>
                      <tr class="font-18">
                        <th style="text-align:left; padding-left:10px">Price</th>
                        <th><h4>Free</h4></th>
                        <th><h4>Free</h4></th>
                      </tr>
                    </tfoot>
                </table>',
                'cloud',
                '<h3 class="font-22">Sign up now for extra features (no cost)</h3>
                <p class="font-18" style="padding-left:12px; margin-top:0">Sign up to create an account on NowButtons.com. Once you\'ve confirmed your account via email, Call Now Button is automatically upgraded to ' . esc_html(CNB_CLOUD_NAME) . '.</p>' .
                CnbHeaderNotices::cnb_settings_email_activation_input(),
                'none'
            );
            ?>
        </div>
    <?php }

    function upgrade_faq() {
        ?>
        <div style="max-width:800px;">
            <h1 class="cnb-center">FAQ</h1>
            <h3>Is a NowButtons.com account really free?</h3>
            <p>Yes. NowButtons has a paid plan as well, however the features described above are all part of the Starter plan which is free. Enter your email above and click <b>Create account</b> to sign up and enable the extra features.</p>
            <h3>Is there a PRO plan?</h3>
            <p>Yes, NowButtons offers a PRO plan with many advanced feature for even more buttons and more control.</p>
            <h3>What's included in PRO?</h3>
            <p>PRO turns your website into a conversion machine. It adds a big collection of premium features such as scheduling, multi-action buttons, animations, WhatsApp Chat window, and much much more. Checkout <a href="<?php echo esc_html(CNB_WEBSITE) ?>pricing/" target="_blank"><?php echo esc_html(CNB_WEBSITE) ?>pricing/</a> for a full features overview.</p>
            <h3>Why do I have to sign up for <?php echo esc_html(CNB_CLOUD_NAME); ?>?</h3>
            <p>NowButtons is a cloud service and can be added to any website. Even those that do not have a WordPress powered website. Once you've signed up, you can continue to manage your buttons from your WordPress instance, but you could also do this via the web app found at <a href="<?php echo esc_html(CNB_APP) ?>" target="_blank"><?php echo esc_html(CNB_APP) ?></a>.</p><p>And should you ever move to a different CMS, your button(s) will just move with you.</p>
        </div>
    <?php }

    public function render() {
        do_action( 'cnb_init', __METHOD__ );
        wp_enqueue_script( CNB_SLUG . '-settings' );
        wp_enqueue_script( CNB_SLUG . '-premium-activation' );

        add_action( 'cnb_header_name', array( $this, 'header' ) );
        do_action( 'cnb_header' );
        ?>

        <div class="cnb-one-column-section">
            <div class="cnb-body-content">
                <div class="cnb-compare-features" style="max-width:800px;">
                    <?php $this->feature_comparison_free_promobox() ?>
                </div>
                <?php $this->upgrade_faq() ?>
            </div>
        </div>
        <hr>
        <?php
        do_action( 'cnb_footer' );
        do_action( 'cnb_finish' );
    }
}
